import csv
import os
import time

import numpy as np
import pandas as pd
root='/Users/yumingwu/Downloads/Stk_Day_QFQ/'
path =os.listdir(root)
path.sort()
num =45
day=time.strftime("%Y-%m-%d",time.localtime())
day_y='20230511'
with open('./'+day+'-000.csv','w',encoding='gbk',newline='') as csfile:
    writer =csv.writer(csfile)
    writer.writerow(['代码','日期','成交量','成交额','换手率','金额','10日涨幅','流通市值'])
    guben = pd.read_excel('/Users/yumingwu/Desktop/流通A股/全部A股_20230414.xlsx')
    for spath in path:
        # 过滤000
        if spath.find("SZ0") == -1:
            continue

        print(spath)
        data = pd.read_csv(root + spath, encoding='gbk')
        data = data.iloc[len(data) - num - 1:len(data)]
        data['时间'] = pd.to_datetime(data['时间'])

        if(len(data)<num+1):
            continue
        zhangting = 0
        for i in np.arange(len(data)):
            if i > 0:
                item0 = data.iloc[i - 1]
                item1 = data.iloc[i]
                if item1['最高价'] / item0['收盘价'] > 1.098:
                    zhangting = 1
                    break

        if zhangting == 0:

            item = data.iloc[-1]
            if item['时间'] != pd.to_datetime(day_y):
                continue
            data10=data.iloc[len(data) - 10 - 1:len(data)]
            minprice=data10['开盘价'].min()
            zhangfu = item['收盘价'] / minprice
            # if zhangfu >= 1.15:
            #     continue
            code = item['代码'][2:8] + "." + item['代码'][0:2]
            gubenitem = guben[guben['证券代码'] == code]
            if len(gubenitem) == 0:
                continue
            gubenitem = gubenitem.iloc[0]

            shizhi = gubenitem['流通A股'] * item['收盘价'] / 100000000.0
            if shizhi > 200:
                continue

            writer.writerow([item['代码'],
                             item['时间'],
                             item['成交量(股)'],
                             item['成交额(元)'],
                             item['成交量(股)'] / gubenitem['流通A股'],
                             660000,
                             zhangfu,
                             shizhi
                             ])










with open('./'+day+'-600.csv','w',encoding='gbk',newline='') as csfile:
    writer =csv.writer(csfile)
    writer.writerow(['代码','日期','成交量','成交额','换手率','金额','10日涨幅','流通市值'])
    guben = pd.read_excel('./全部A股.xlsx')
    for spath in path:
        # 过滤000
        if spath.find("SH60") == -1:
            continue

        print(spath)
        data = pd.read_csv(root + spath, encoding='gbk')
        data = data.iloc[len(data) - num - 1:len(data)]
        data['时间'] = pd.to_datetime(data['时间'])

        if(len(data)<num+1):
            continue
        zhangting = 0
        for i in np.arange(len(data)):
            if i > 0:
                item0 = data.iloc[i - 1]
                item1 = data.iloc[i]
                if item1['最高价'] / item0['收盘价'] > 1.098:
                    zhangting = 1
                    break

        if zhangting == 0:

            item = data.iloc[-1]
            if item['时间'] != pd.to_datetime(day_y):
                continue
            data10=data.iloc[len(data) - 10 - 1:len(data)]
            minprice=data10['开盘价'].min()
            zhangfu = item['收盘价'] / minprice
            # if zhangfu >= 1.15:
            #     continue
            code = item['代码'][2:8] + "." + item['代码'][0:2]
            gubenitem = guben[guben['证券代码'] == code]
            if len(gubenitem) == 0:
                continue
            gubenitem = gubenitem.iloc[0]

            shizhi = gubenitem['流通A股'] * item['收盘价'] / 100000000.0
            if shizhi > 200:
                continue

            writer.writerow([item['代码'],
                             item['时间'],
                             item['成交量(股)'],
                             item['成交额(元)'],
                             item['成交量(股)'] / gubenitem['流通A股'],
                             300000,
                             zhangfu,
                             shizhi
                             ])

with open('./'+day+'-300.csv','w',encoding='gbk',newline='') as csfile:
    writer =csv.writer(csfile)
    writer.writerow(['代码','日期','成交量','成交额','换手率','金额','10日涨幅','流通市值'])
    guben = pd.read_excel('./全部A股.xlsx')
    for spath in path:
        # 过滤000
        if spath.find("SZ30") == -1:
            continue

        print(spath)
        data = pd.read_csv(root + spath, encoding='gbk')
        data = data.iloc[len(data) - num - 1:len(data)]
        data['时间'] = pd.to_datetime(data['时间'])

        if(len(data)<num+1):
            continue
        zhangting = 0
        for i in np.arange(len(data)):
            if i > 0:
                item0 = data.iloc[i - 1]
                item1 = data.iloc[i]
                if item1['最高价'] / item0['收盘价'] > 1.098:
                    zhangting = 1
                    break

        if zhangting == 0:

            item = data.iloc[-1]
            if item['时间'] != pd.to_datetime(day_y):
                continue
            data10=data.iloc[len(data) - 10 - 1:len(data)]
            minprice=data10['开盘价'].min()
            zhangfu = item['收盘价'] / minprice
            # if zhangfu >= 1.15:
            #     continue
            code = item['代码'][2:8] + "." + item['代码'][0:2]
            gubenitem = guben[guben['证券代码'] == code]
            if len(gubenitem) == 0:
                continue
            gubenitem = gubenitem.iloc[0]

            shizhi = gubenitem['流通A股'] * item['收盘价'] / 100000000.0
            if shizhi > 200:
                continue

            writer.writerow([item['代码'],
                             item['时间'],
                             item['成交量(股)'],
                             item['成交额(元)'],
                             item['成交量(股)'] / gubenitem['流通A股'],
                             300000,
                             zhangfu,
                             shizhi
                             ])


